mods["RoRRModdingToolkit-RoRR_Modding_Toolkit"].auto()

local share_item_enabled = true
gui.add_to_menu_bar(function()
    local new_value, clicked = ImGui.Checkbox("Enable Share Item", share_item_enabled)
    if clicked then
        share_item_enabled = new_value
    end
end)

local function add_chat_message(text)
    gm.chat_add_message(gm["@@NewGMLObject@@"](gm.constants.ChatMessage, text))
end

local currently_giving = false
gm.post_script_hook(gm.constants.item_give, function(self, other, result, args)
    if share_item_enabled and not currently_giving then
        local actor = args[1].value
        local item_id = args[2].value
        local count = args[3].value
        local stack_kind = args[4].value

        if actor.object_index == gm.constants.oP then
            -- local ror = Item.find_all(Item.TIER.common)
            -- print(#ror)
            -- for k, v in pairs(ror) do
            --     print(v.value .. " " .. v.identifier)
            -- end

            -- local ror = Item.find_all("ror")
            -- for k, v in pairs(ror) do
            --     print(v.value .. " " .. v.identifier)
            -- end

            -- for i = 0, 136, 1 do
            --     local item = Item.wrap(i)
            --     if item  ~= i then
            --         print(item.value .. ": " .. item.identifier .. " tier: " .. item.tier)
            --     end
            -- end

            local item = Item.wrap(item_id)
            local tier = item.tier

            if tier == 3 or tier >= 5 then
                -- dont distribute equipment, special items, food items, and other
                -- -> means we only distribute common, uncommon, rare, boss
                return
            end

            print("Distributing item " .. item.identifier .. " (" .. item.value .. ") of tier " .. tier)

            gm.item_take(actor, item_id, count, stack_kind)

            local lowestPlayer = actor

            local pickupPlayerItemCount = 0

            -- NOTE: Item.find_all(tier) does not work at all?
            -- find relevant items manually...

            local comparable_items = {}
            -- This does not work for mod items -> will need to manually handle any new ids... unfortunately Item.find_all(tier) does not work...
            for i = 0, 136, 1 do
                local item = Item.wrap(i)
                if item.tier == tier then
                    comparable_items[i] = i
                    -- print("comparable: " .. item.value .. " " .. item.identifier .. " table index " .. i)
                end
            end

            for k, v in pairs(comparable_items) do
                local index = k + 1
                pickupPlayerItemCount = pickupPlayerItemCount + actor.inventory_item_stack[index]
                -- print("player has " .. actor.inventory_item_stack[index] .. " of item " .. k)
            end

            print(actor.user_name .. " (" .. actor.name .. ") has " .. pickupPlayerItemCount .. " items of tier " .. tier)
            local lowestItemCount = pickupPlayerItemCount

            for i = 1, #gm.CInstance.instances_active do
                local inst = gm.CInstance.instances_active[i]
                if inst.object_index == gm.constants.oP and inst.id ~= actor.id then
                    local currentItemCount = 0

                    for k, v in pairs(comparable_items) do
                        local index = k + 1
                        currentItemCount = currentItemCount + inst.inventory_item_stack[index]
                    end

                    if currentItemCount < lowestItemCount then
                        lowestPlayer = inst
                    end
                    print(inst.user_name ..
                    " (" .. inst.name .. ") has " .. currentItemCount .. " items of tier " .. tier)
                end
            end

            currently_giving = true

            print("Giving item " ..
            item.identifier .. " (" .. item_id .. ") to " .. lowestPlayer.user_name .. " (" .. lowestPlayer.name .. ")")
            gm.item_give(lowestPlayer, item_id, count, stack_kind)

            currently_giving = false
        end
    end
end)

gui.add_imgui(function()
    if ImGui.Begin("Share Item Debug") then
        if ImGui.Button("Give Gold") then
            for i = 1, #gm.CInstance.instances_active do
                local inst = gm.CInstance.instances_active[i]
                if inst.object_index == gm.constants.oP then
                    gm.drop_gold_and_exp(inst.x, inst.y, 500)
                    add_chat_message("Giving gold to " .. inst.user_name .. " (" .. inst.name .. ")")
                    break
                end
            end
        end

        ImGui.End()
    end
end)
